clear
filenames=['wna.wind.199907.grb'
    'wna.wind.199908.grb'
    'wna.wind.199909.grb'
    'wna.wind.199910.grb'
    'wna.wind.199911.grb'
    'wna.wind.199912.grb'
    'wna.wind.200001.grb'
    'wna.wind.200002.grb'
    'wna.wind.200003.grb'
    'wna.wind.200004.grb'
    'wna.wind.200005.grb'
    'wna.wind.200006.grb'
    'wna.wind.200007.grb'
    'wna.wind.200008.grb'
    'wna.wind.200009.grb'
    'wna.wind.200010.grb'
    'wna.wind.200011.grb'
    'wna.wind.200012.grb'
    'wna.wind.200101.grb'
    'wna.wind.200102.grb'
    'wna.wind.200103.grb'
    'wna.wind.200104.grb'
    'wna.wind.200105.grb'
    'wna.wind.200106.grb'
    'wna.wind.200107.grb'
    'wna.wind.200108.grb'
    'wna.wind.200109.grb'
    'wna.wind.200110.grb'
    'wna.wind.200111.grb'
    'wna.wind.200112.grb'
    'wna.wind.200201.grb'
    'wna.wind.200202.grb'
    'wna.wind.200203.grb'
    'wna.wind.200204.grb'
    'wna.wind.200205.grb'
    'wna.wind.200206.grb'
    'wna.wind.200207.grb'
    'wna.wind.200208.grb'
    'wna.wind.200209.grb'
    'wna.wind.200210.grb'
    'wna.wind.200211.grb'
    'wna.wind.200212.grb'
    'wna.wind.200301.grb'
    'wna.wind.200302.grb'
    'wna.wind.200303.grb'
    'wna.wind.200304.grb'
    'wna.wind.200305.grb'
    'wna.wind.200306.grb'
    'wna.wind.200307.grb'
    'wna.wind.200308.grb'
    'wna.wind.200309.grb'
    'wna.wind.200310.grb'
    'wna.wind.200311.grb'
    'wna.wind.200312.grb'
    'wna.wind.200401.grb'
    'wna.wind.200402.grb'
    'wna.wind.200403.grb'
    'wna.wind.200404.grb'
    'wna.wind.200405.grb'
    'wna.wind.200406.grb'
    'wna.wind.200407.grb'
    'wna.wind.200408.grb'
    'wna.wind.200409.grb'
    'wna.wind.200410.grb'
    'wna.wind.200411.grb'
    'wna.wind.200412.grb'
    'wna.wind.200501.grb'
    'wna.wind.200502.grb'
    'wna.wind.200503.grb'
    'wna.wind.200504.grb'
    'wna.wind.200505.grb'
    'wna.wind.200506.grb'
    'wna.wind.200507.grb'
    'wna.wind.200508.grb'
    'wna.wind.200509.grb'
    'wna.wind.200510.grb'
    'wna.wind.200511.grb'
    'wna.wind.200512.grb'
    'wna.wind.200601.grb'
    'wna.wind.200602.grb'
    'wna.wind.200603.grb'
    'wna.wind.200604.grb'
    'wna.wind.200605.grb'
    'wna.wind.200606.grb'
    'wna.wind.200607.grb'
    'wna.wind.200608.grb'
    'wna.wind.200609.grb'
    'wna.wind.200610.grb'
    'wna.wind.200611.grb'
    'wna.wind.200612.grb'
    'wna.wind.200701.grb'
    'wna.wind.200702.grb'
    'wna.wind.200703.grb'
    'wna.wind.200704.grb'
    'wna.wind.200705.grb'
    'wna.wind.200706.grb'
    'wna.wind.200707.grb'
    'wna.wind.200708.grb'
    'wna.wind.200709.grb'
    'wna.wind.200710.grb'
    'wna.wind.200711.grb'];

days=[31;31;30;31;30;31;
    31;29;31;30;31;30;31;31;30;31;30;31;
    31;28;31;30;31;30;31;31;30;31;30;31;
    31;28;31;30;31;30;31;31;30;31;30;31;
    31;28;31;30;31;30;31;31;30;31;30;31;
    31;29;31;30;31;30;31;31;30;31;30;31;
    31;28;31;30;31;30;31;31;30;31;30;31;
    31;28;31;30;31;30;31;31;30;31;30;31;
    31;28;31;30;31;30;31;31;30;31;30];

timesteps=days*8+1;

domain=[-97.75 -96.75 26 27;
    -97.75 -96.75 27 28;
    -97.25 -96.25 27.5 28.5;
    -96.75 -95.5 28 29;
    -95.5 -93.5 28.75 30;
    -98 -93 26 30
    -98.25 -29.75 -0.25 50.25
    -98 -70 15 35];

for t=94:101
    fname1=filenames(t,:);
    fname2=['WINDS',num2str(t)];
    steps=timesteps(t);

    eval(['[status, result] = dos(''wgrib ',fname1,' -d all -text -nh -o ',fname2,'.out'');']);
    eval(['load ',fname2,'.out -ascii']);
    R=[];
    n=1; m=275*203;
    for i = 1 : steps
        data=[];
        eval(['dat = ',fname2,'(n:m);']);
        n = m + 1;
        m = m + 275*203;
        j = 1;
        for k = 1 : 203
            data(:,204-k)=dat(j:j+274);
            j = j + 275;
        end
        data = data';
        eval(['save WUGRD',num2str(i),'.mat data']);

        data=[];
        eval(['dat = ',fname2,'(n:m);']);
        n = m + 1;
        m = m + 275*203;
        j = 1;
        for k = 1 : 203
            data(:,204-k)=dat(j:j+274);
            j = j + 275;
        end
        data = data';
        eval(['save WVGRD',num2str(i),'.mat data']);
    end
    clear R WIN* dat* i j k m n result status
    % Join the separate files into one single file"
    for ii = 1 : steps
        I = num2str(ii);
        eval(['load WUGRD',I]);
        eval(['WUGRD',I,'=data;'])
        eval(['delete WUGRD',I,'.mat'])
        clear data
    end
    eval(['save WUGRD',num2str(t),'.mat WU*']);
    clear WU* I ii

    for ii = 1 : steps
        I = num2str(ii);
        eval(['load WVGRD',I]);
        eval(['WVGRD',I,'=data;'])
        eval(['delete WVGRD',I,'.mat'])
        clear data
    end
    eval(['save WVGRD',num2str(t),'.mat WV*']);
    clear WV* I ii


    % Extract the Gulf of Maine Results from the Generated File

    lon = -98.25 : 0.25 : -29.75;
    lat = - 0.25 : 0.25 :  50.25;
    for dm=8:8;
        lons = find(lon==domain(dm,1));
        lone = find(lon==domain(dm,2));
        lats = find(lat==domain(dm,3));
        late = find(lat==domain(dm,4));
        lonx = lon(lons:lone);
        laty = lat(lats:late);

        eval(['load WUGRD',num2str(t),'.mat;']);
        eval(['load WVGRD',num2str(t),'.mat;']);
        
        for jj = 1 : steps
            J = int2str(jj);
            eval(['GOM_WUGRD',J,'= WUGRD',J,'(lats:late,lons:lone);'])
            eval(['GOM_WVGRD',J,'= WVGRD',J,'(lats:late,lons:lone);'])
            eval(['clear WUGRD',J])
            eval(['clear WVGRD',J])
        end
        eval(['save GOM_WUGRD_file',num2str(t),'_dm',num2str(dm),'.mat GOM_WU*;']);
        eval(['save GOM_WVGRD_file',num2str(t),'_dm',num2str(dm),'.mat GOM_WV*;']);
        clear jj J
        
        [b,a]=size(GOM_WUGRD1);
        x=[];
        y=[];
        x1=1:a;
        y1=ones(1,a);
        for jj=1:b
            x=[x,x1];
        end
        for jj=1:b
            y=[y y1*jj];
        end
        x=domain(dm,1)+(x-1)*1/5;
        y=domain(dm,3)+(y-1)*1/5;

        eval(['fid1=fopen(''GOMWINDS_file',num2str(t),'_dm',num2str(dm),'.dat'',''w+'');']);
        fprintf(fid1,'VARIABLES="X", "Y", "WUG", "WVG", "WSP"\n');
%         point1(3,steps)=0;
%         point2(3,steps)=0;
        for jj=1:steps
            J = int2str(jj);
            r=fix(jj/8);
            eval(['u1=reshape((GOM_WUGRD',J,')'',[1,a*b]);']);
            eval(['u2=reshape((GOM_WVGRD',J,')'',[1,a*b]);']);
            op=[x;y;u1;u2;sqrt(u1.^2+u2.^2)];
%             eval(['op=[x;y;reshape((GOM_WUGRD',J,')'',[1,a*b]);reshape((GOM_WVGRD',J,')'',[1,a*b])];']);
            eval(['fprintf(fid1,''ZONE I=',num2str(a),' J=',num2str(b),' F=POINT\n'');']);
            fprintf(fid1,'%6.4f %6.4f %6.4f %6.4f %6.4f\n',op);
            tm=['fprintf(fid1,''TEXT,X=74,Y=85,T="',fname1(10:13),' ',fname1(14:15),' ',num2str(r+1),'th", F=COURIER, CS=FRAME, H=2, ZN=',num2str(jj),'\n'');'];
            eval(tm);
%             point1(:,t)=op(:,181*58+24);
%             point2(:,t)=op(:,181*60+151);
        end
        clear GOM_W*
        fclose(fid1);
    end
end